/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.end;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2169;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3541;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6544;
import net.minecraft.class_6780;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.common.world.biome.end.EndBiomesConfig;
import potionstudios.byg.mixin.access.BiomeSourceAccess;
import potionstudios.byg.util.BYGUtil;

public abstract class BYGEndBiomeSource
extends class_1966 {
    public static final class_2960 LOCATION = BYG.createLocation("end");
    private final class_3541 islandNoise;
    private final class_2378<class_1959> biomeRegistry;
    private final class_6780 islandBiomeResolver;
    private final class_6780 voidBiomeResolver;
    private final class_6780 skyBiomeResolver;
    private final int skyLayersStartY;
    private final long seed;

    protected BYGEndBiomeSource(class_2378<class_1959> biomeRegistry, long seed) {
        super(BYGEndBiomeSource.getPossibleBiomes(biomeRegistry));
        this.biomeRegistry = biomeRegistry;
        this.seed = seed;
        class_2919 worldgenrandom = new class_2919((class_5819)new class_5820(seed));
        worldgenrandom.method_33650(17292);
        this.islandNoise = new class_3541((class_5819)worldgenrandom);
        EndBiomesConfig config = EndBiomesConfig.getConfig();
        Set possibleBiomes = ((BiomeSourceAccess)((Object)this)).byg_getPossibleBiomes().stream().map(class_6880::method_40230).map(Optional::orElseThrow).collect(Collectors.toSet());
        BiPredicate<Collection<class_5321<class_1959>>, class_5321<class_1959>> filter = (existing, added) -> !existing.contains(added) && possibleBiomes.contains(added);
        this.islandBiomeResolver = this.getIslandBiomeResolver(biomeRegistry, seed, config.islandLayers().filter(filter));
        this.voidBiomeResolver = this.getVoidBiomeResolver(biomeRegistry, seed, config.voidLayers().filter(filter));
        this.skyBiomeResolver = this.getSkyBiomeResolver(biomeRegistry, seed, config.skyLayers().filter(filter));
        this.skyLayersStartY = class_5742.method_33100((int)config.skyLayerStartY());
    }

    public abstract class_6780 getIslandBiomeResolver(class_2378<class_1959> var1, long var2, LayersBiomeData var4);

    public abstract class_6780 getVoidBiomeResolver(class_2378<class_1959> var1, long var2, LayersBiomeData var4);

    public abstract class_6780 getSkyBiomeResolver(class_2378<class_1959> var1, long var2, LayersBiomeData var4);

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        int chunkX = x >> 2;
        int chunkZ = z >> 2;
        if ((long)chunkX * (long)chunkX + (long)chunkZ * (long)chunkZ <= 4096L) {
            return this.biomeRegistry.method_40290(class_1972.field_9411);
        }
        if (y > this.skyLayersStartY) {
            return this.skyBiomeResolver.method_38109(x, y, z, sampler);
        }
        float heightValue = class_2169.method_8757((class_3541)this.islandNoise, (int)(chunkX * 2 + 1), (int)(chunkZ * 2 + 1));
        if (heightValue > 40.0f) {
            return this.islandBiomeResolver.method_38109(x, y, z, sampler);
        }
        if (heightValue >= 0.0f) {
            return this.islandBiomeResolver.method_38109(x, y, z, sampler);
        }
        return heightValue < -20.0f ? this.voidBiomeResolver.method_38109(x, y, z, sampler) : this.islandBiomeResolver.method_38109(x, y, z, sampler);
    }

    protected class_2378<class_1959> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    protected long getSeed() {
        return this.seed;
    }

    @NotNull
    private static List<class_6880<class_1959>> getPossibleBiomes(class_2378<class_1959> biomeRegistry) {
        EndBiomesConfig config = EndBiomesConfig.getConfig(false, false, biomeRegistry);
        TreeSet<String> missingBiomes = new TreeSet<String>();
        BiPredicate<Collection<class_5321<class_1959>>, class_5321<class_1959>> filter = (existing, added) -> {
            boolean biomeRegistryHas = biomeRegistry.method_35842(added);
            if (!biomeRegistryHas) {
                missingBiomes.add(added.method_29177().toString());
            }
            return !existing.contains(added) && biomeRegistryHas;
        };
        LayersBiomeData usedIslandLayer = config.islandLayers().filter(filter);
        LayersBiomeData usedVoidLayer = config.voidLayers().filter(filter);
        LayersBiomeData usedSkyLayer = config.skyLayers().filter(filter);
        String ignored = BYGUtil.dumpCollection(missingBiomes);
        if (!ignored.isEmpty()) {
            BYG.LOGGER.warn(String.format("Config \"%s\" warned:\nThe following biome entries were ignored due to not being in this world's biome registry:\n%s", EndBiomesConfig.CONFIG_PATH.get(), ignored.toString()));
        }
        List<class_6880<class_1959>> biomesFromBiomeData = BYGUtil.createBiomesFromBiomeData(biomeRegistry, usedIslandLayer, usedVoidLayer, usedSkyLayer);
        biomesFromBiomeData.add((class_6880<class_1959>)biomeRegistry.method_40290(class_1972.field_9411));
        return biomesFromBiomeData;
    }
}

